<?php
session_start();
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 405 Method Not Allowed');
	die();
}
if ($_SESSION['status'] != 'teacher') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 403 Forbidden');
	die();
}
if (!isset($_POST['password'])) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad Request');
	die();
}
if ($_POST['password'] != $teacher_password) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 403 Forbidden');
	header('Location: index.php?error=Mauvais mot de passe.');
	die();
}

try {
	$pdo = new PDO($db_dsn, $db_user, $db_password);
} catch (PDOException $e) {
	print($e->getMessage());
	die();
}

$pdo->query('DELETE FROM Vote');
$pdo->query('DELETE FROM Participation');
$pdo->query('DELETE FROM Student');
$pdo->query('DELETE FROM Tutor');


if (isset($_GET['fake'])) { /*FAKER*/
	$students = [['TAMA', 'Teura'], ['MIRI', 'Tiare'], ['HIRO', 'Taina'], ['RAI', 'Vaira'], ['TANE', 'Moana'], ['MOE', 'Hina'], ['MARTIN', 'Sophie'], ['BERNARD', 'Pierre'],
                 ['TUI', 'Rima'], ['ARI', 'Lani'], ['ROA', 'Anuhea'], ['HUA', 'Tefana'], ['NUI', 'Marama'], ['TAHI', 'Aroha'], ['LEROY', 'Claire'], ['MOREAU', 'Luc'],
                 ['VAI', 'Herenui'], ['RIRI', 'Tefiti'], ['PUA', 'Tahiata'], ['HINA', 'Tiare'], ['MATA', 'Vaitiare'], ['TAMA', 'Rarahu'], ['GARNIER', 'Émilie'], ['ROUX', 'Thomas']];
	$tutors = [['ROA', 'Tehani'], ['HIRO', 'Taina'], ['DUPONT', 'Jean'], ['LEMOINE', 'Isabelle'], ['FAURE', 'Julien'], ['BLANC', 'Céline']];
	foreach ($students as $item) $pdo->query("INSERT INTO Student (firstname, lastname) VALUES ('$item[1]', '$item[0]')");
	foreach ($tutors as $item) $pdo->query("INSERT INTO Tutor (firstname, lastname) VALUES ('$item[1]', '$item[0]')");
	$minStudent = $pdo->query('SELECT MIN(id) AS id FROM Student')->fetch(PDO::FETCH_OBJ)->id;
	$maxStudent = $pdo->query('SELECT MAX(id) AS id FROM Student')->fetch(PDO::FETCH_OBJ)->id;
	$minTutor = $pdo->query('SELECT MIN(id) AS id FROM Tutor')->fetch(PDO::FETCH_OBJ)->id;
	$maxTutor = $pdo->query('SELECT MAX(id) AS id FROM Tutor')->fetch(PDO::FETCH_OBJ)->id;
	$voteCount = ($maxTutor - $minTutor + 1) * intdiv(($maxStudent - $minStudent + 1), rand(3,6));
	for ($i=0; $i<$voteCount; $i++) {
		$idStudent = rand($minStudent, $maxStudent);
		$idTutor = rand($minTutor, $maxTutor);
		try {
			$pdo->query("INSERT INTO Vote (idStudent, idTutor) VALUES ($idStudent, $idTutor)");
		} catch (PDOException $e) {} //primary key violation due to random
	}
}

header('Location: index.php');
?>
